// OstreamFork.hpp -- Distribute data to 2 streams simultaneously -- 2018-09-14

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef OSTREAMFORK_HPP
#define OSTREAMFORK_HPP

#include <iostream>         // Class ostream
  using namespace std ;

class ostreamFork           // Write same data to two ostreams
{
public:                     // Public for templates
  ostream* os1 ;            // First target stream
  ostream* os2 ;            // Second target stream

                                     // Constructor
  ostreamFork( ostream& os_one ,     // Initial ostream pair
               ostream& os_two )
  : os1( &os_one ) ,
    os2( &os_two )
  {}
                                     // Change streams
  void setStream( ostream& os_one ,  // New ostream pair
                  ostream& os_two )
  {
    os1 = &os_one ;
    os2 = &os_two ;
  }
} ;

                                                 // For endl, flush
 ostreamFork& operator<<( ostreamFork& osf , 
                          ostream& (*f)(ostream&) ) ;

 extern ostreamFork cout_cerr ;                  // Dual progress stream

                      // For data with insertion operator: int, long , ...
 template <class Data>
 ostreamFork& operator<<( ostreamFork& osf , Data d )
 {
   *(osf.os1) << d ; 
   *(osf.os2) << d ;
   return osf ;
 }

                             // For setw() , ...
template<class ManipData>
 ostreamFork& operator<<( ostreamFork& osf , ostream& (*f)(ostream&, ManipData )  )
 {
   *(osf.os1) << f ; 
   *(osf.os2) << f ;
   return osf ;
 }

#endif