// SystemUtilities.hpp -- Interface to Operating System -- 2018-09-21

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef SYSTEMUTILITIES_HPP
#define SYSTEMUTILITIES_HPP

#include <string>                                 // Class String
#include "Prime.hpp"                              // typedefs
#include <string>                                 // Class string
#include <algorithm>                              // remove()
  using namespace std;

string getTempDirectory() ;                       // Directory name for tmp file

void   systemError( int v , const string& c ) ;   // Report system errors

void   execute( const string& cmd ,               // Execute DOS command
                const string& errorMsg = "" ) ;

void   deleteFile(  const string& fileName ) ;    // Delete file fileName

void   setReadOnly( const string& fileName ) ;    // fileName set read only

void   zeroBinaryFile( fstream& file ,            // Binary file fileName
                       offset length ) ;          //  with length, all zero bytes

string fileNameFromPath( const string& path ) ;   // Following last "/"

string fileExtFromPath(  const string& path ) ;   // Following last period

string limitsToFilename( PrimeRange start ,       // start_to_end (12 digits)
                         PrimeRange end ) ;

bool   taskActive( string& name ) ;               // Is task "name" running?

inline void deleteChar( string& s , char c )      // Remove c from s
{
  s.erase( remove( s.begin(), s.end(), c ) , s.end() ) ;
}

#endif