// StopWatch.hpp - Report time intervals -- 2018-09-10

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef STOPWATCH_HPP
#define STOPWATCH_HPP

#include <ctime>              // std::clock_t 
                              // CLOCKS_PER_SEC
                              // std::clock() 

#include "Prime.hpp"          // PrimeRange

class StopWatch
{
private:
  const std::clock_t birth ;   // Time of construction
        std::clock_t start ;   // Start of current interval

public:
         StopWatch() ; 
  double interval() const ;    // Seconds since constructor or restart()
  double seconds()  const ;    // Seconds since constructor 
  double hours()    const ;    // Hours since constructor 
  double secondsPerEvent( const PrimeRange events ) const ;  // Seconds per event
  double usPerEvent(      const PrimeRange events ) const ;  // MicroSeconds per event
  void   restart();            // Set start time
} ;

#endif