// StopWatch.hpp - Report time intervals -- 2018-09-10

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                 // Microsoft Boilerplate
#include "StopWatch.hpp"            // Class Stopwatch

static const double 
    scale( 1.0/(CLOCKS_PER_SEC)) ;  // Seconds per click

 StopWatch::StopWatch( )            // Constructor
 : birth( std::clock() ) ,          // Time constructed
   start( birth )                   // Per event interval start
 { }
                                    // Seconds since constructor
                                    // or restart()
 double StopWatch::interval() const
 {  
   std::clock_t now = std::clock() ;  // Current time
   return ( now - start ) * scale ;  
 } 

 double StopWatch::seconds() const   // Seconds since constructor
 {  
   std::clock_t  now = std::clock() ;  // Current time
   return ( now - birth ) * scale ;   
 } 

 double StopWatch::hours() const    // Hours since constructor
 {  
   return seconds() / 3600. ;  
 } 
                                  // Interval time in seconds
 double StopWatch::secondsPerEvent( const PrimeRange events ) const
 {
   return interval() / events ;
 }
                                  // Interval time in microseconds
 double StopWatch::usPerEvent( const PrimeRange events ) const 
 {
   return ( 1E6 * secondsPerEvent( events ) ) ;
 }

 void StopWatch::restart()        // Set start of new interval
 {
   start = std::clock() ;         // Now
 }
