// PrimeVector.hpp --  vector of primes beginning with 2 -- 2018-09-24

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef PRIMEVECTOR_HPP
#define PRIMEVECTOR_HPP

#include "Prime.hpp"                 // Typedefs, exceptions
#include "Progress.hpp"              // Class Progress -- Periodic reporting
#include <fstream>                   // Class ifstream
#include <vector>                    // Class vector
  using namespace std ;

const  static PrimeRange LargestPrimeRoot = ULONG_MAX ;

class PrimeVector : public vector<unsigned long>   
{
private:     
  Prime    limit ;                          // Last Prime <= limit
  Progress prog ;                           // Progress timer
  void  seed( ) ;                           // Initial map for construction
  void  extend( const PrimeRange limit ) ;  // Build map to required size

public:
  PrimeVector( const PrimeRange last ) ;    // Last required entry
  PrimeVector( ifstream& prime4 ,           // 32 bit pre-computed prime list
               const PrimeRange last ) ;    // Last required entry
  
  bool  isPrime( const PrimeRange v )  ;  

} ;

#endif
