// PrimeGeneratorC.hpp -- 2018-09-14
// Combine CandidateGenerator and PrimeCArray to generate primes

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef PRIMEGENERATORC_HPP
#define PRIMEGENERATORC_HPP

#include "PrimeCArray.hpp"          // Class PrimeCArray
#include "StopWatch.hpp"            // Class StopWatch
#include "Distribution.hpp"         // Class Distribution
#include "CandidateGenerator.hpp"   // Class CandidateGenerator
#include <fstream>                  // Class ofstream
  using namespace std;

class PrimeGeneratorC               // Generate verified primes
{
private:
  PrimeCArray        pca    ;    // Primes to test candidates:
                                 //   all 32 bit primes

                                 // start and limit are n*20
  PrimeRange         start ,     // Lower bound of primes to return
                     limit ,     // Upper bound of primes to return
                     range ;     // Length of range of primes

  CandidateGenerator cg ;        // Generate prime candidates

                                        // Diagnostics 
  ofstream           listFile ;         // Output file

  long               primeCount ,       // Number of Primes emitted
                     candidateCount ;   // Total candidates vetted

  Distribution< Prime , long > dist ;   // Map of Primes to occurences

public:
  PrimeGeneratorC( PrimeRange fst ,      // Lower bound of prime candidate
                   PrimeRange lst ) ;    // Upper bound of Prime candidate

  PrimeGeneratorC::~PrimeGeneratorC() ;   // Destructor

  bool  primeSearch( const PrimeRange v ) ;   // Is v prime
                                              // Trial division, 0 to sqrt(v)

  Prime get() ;                           // Return next verified prime

} ;

#endif