// PrimeGeneratorC.cpp -- 2018-09-11
// Emit sequence of Primes 
// Starts with first prime after or equal to fst
// Ends with last prime before or equal to lst

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"               // Microsoft Boilerplate
#include "PrimeGeneratorC.hpp"    // Class PrimeGeneratorC
#include "PrimeCFileReader.hpp"   // Class PrimeCFireReader
#include "OstreamFork.hpp"        // cout_cerr
#include <fstream>                // Class fstream
  using namespace std ;  

                                  // Largest possible prime root
                                  // Test divisors < lastRoot
                                  // Add 10 to safety margin
PrimeRange lastRoot( const PrimeRange lst )
{
  PrimeRange sr = static_cast<const PrimeRange>( sqrt( lst ) ) ;

  if ( sr + 10 < Largest32bit )    // Room for +10 margin
    sr+=10 ;                       // Yes
  else 
    sr = Largest32bit ;            // No

  return sr ;
}    
                                // Constructor
                         
PrimeGeneratorC::PrimeGeneratorC( const PrimeRange fst ,  // First Prime   
                                  const PrimeRange lst )  // Last prime
: start( fst ) ,            // First prime
  limit( lst ) ,            // Last Prime
  cg( fst ) ,               // CandidateGenerator
  range( lst - fst )  ,     // Range (not count) of primes
  primeCount(0) ,           // Primes generated 
  candidateCount(0) ,       // Candidates processed
  pca()                     // PrimeCArray to test candidates
{ 
  if ( fst >= lst )
    throw Range( "PrimeGenerator::PrimeGenerator() ;  first > last" ) ;

                            // Load precomputed primes for trial divisors
                            // PrimeException if not found
//PrimeCFileReader pcf(   "00000000000_to_04294967300.primec" ) ; 
  PrimeCFileReader pcf( "000000000000_to_010000000000.primec" ) ; 
  pca = pcf ;               // Copy to array cache
} 

PrimeGeneratorC::~PrimeGeneratorC()       // Destructor for statistics
{                                         // To be deleted
//  list << endl  << candidateCount 
//       << " : " << primeCount << endl ;
//  dist.list( list ) ; 
}

Prime PrimeGeneratorC::get( )    // Filter non-primes from candidate generator
{ 
  PrimeRange candidate ;

  while ( true )
  {
    candidate = cg.next() ;       // Get prime candidate, 
                                  //   ends in 1, 3, 7 ,9
   
    if ( candidate > limit )      // Finished (not error)
      throw EndOfFile( "Prime candidate > limit" ) ;

    candidateCount++ ;            // For statistics

    if ( !primeSearch( candidate ) )   // If not prime, get another candidate
      continue ;
  
    primeCount++ ;                    // For statistics
    return candidate ;                // Prime, return
  }   // End  while 
}

bool  PrimeGeneratorC::primeSearch( const PrimeRange v ) 
{      
                           // Candidate generator output v
                           //   ends in 1, 3, 7, 9 and 
                           //   discards multiples of 3 and 7
                           // Search for factor starting
                           // with 11 to sqrt(v)

  PrimeRange factorCount = 1 ;  // For progress report

  const Prime lastFactor = 
      static_cast<Prime>( ceil( sqrt(v) ) ) ;  
 
                                  // List of precomputed primes
  auto i = pca.find(11) ;         // Iterator starts with 11

  while( true )
  {
//     i++ will throw exception
 //   if ( *i == pca.last()  )      // End of vector ? (2^32)
//    {                             // Yes, Factor not found
//      return true ; 
  //    throw EndOfFile( "PrimeVector::isPrime() missed sqrt(v)" ) ;  
 //   }

    Prime factor = *i ; 

    if  ( factor > lastFactor)   // Checked up to sqrt(v)
      break ;                    // Yes, Not found, quit
         // return true ;

    if ( 0 == v % factor )       // Found factor
    {
 //     cout_cerr << endl << v << " is not prime." << endl ;  // Diagnosic
      return false ;             // Yes, not prime
    }

    i++ ;                                  // Next vector prime

 //   if ( 0 == factorCount++ % 10000000 )   // Progress report
 //   {
 //     cout_cerr << v 
 //               << " Factor count: " <<factorCount 
 //               << ",  Factor: " << factor << "    \r" ;
//    }
  }
    
 // cout_cerr << endl << v << " is prime." << endl ;  // Diagnosic

  return true ;                        // No factors found
}


