// PrimeGenerator.hpp -- 2018-09-24
// Combine CandidateGenerator and PrimeVector to generate primes

#ifndef PRIMEGENEEATOR_HPP
#define PRIMEGENEEATOR_HPP

#include "PrimeVector.hpp"         // Class PrimeVector
#include "StopWatch.hpp"           // Class StopWatch
#include "Distribution.hpp"        // Class Distribution
#include "CandidateGenerator.hpp"  // Class CandidateGenerator
#include <fstream>                 // Class ofstream

class PrimeGenerator               // Generate verified primes
{
private:
  PrimeVector        pv    ;    // Vector of primes to test candidaies
  PrimeRange         start ,    // First prime to return
                     limit ,    // Last prime to return
                     range ;    // Length of range of primes

  CandidateGenerator cg ;       // Generate prime candidates

                                        // Diagnostic 
  ofstream           listFile ;         // Output file

  long               primeCount ,       // Number of Primes emitted
                     candidateCount ;   // Total candidates vetted

  Distribution< Prime , long > dist ;   // Map of Primes to occurences

public:
  PrimeGenerator( PrimeRange fst ,      // First prime candidate
                  PrimeRange lst ) ;    // Last Prime candidate

  Prime get() ;                  // Return next verified prime

} ;

#endif