// PrimeGenerator.cpp -- 2018-09-24
// Emit sequence of Primes
// Starts with first prime after or equal to fst
// Ends with last prime before or equal to lst

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"               // Microsoft Boilerplate
#include "PrimeGenerator.hpp"     // Class PrimeGenerator
#include <fstream>                // Class fstream
  using namespace std ;  

                                  // Largest possible prime root
PrimeRange lastRoot( const PrimeRange lst )
{
  PrimeRange sr = static_cast<const PrimeRange>( sqrt( lst ) );
  if ( sr + 10 < Largest32bit )
    sr+=10 ;
  else 
    sr = Largest32bit ;
  return sr ;
}    
                                                        // Constructor                         
PrimeGenerator::PrimeGenerator( const PrimeRange fst ,  // First Prime   
                                const PrimeRange lst )  // Last prime
: pv( lastRoot( lst ) ) ,
  start( fst ) ,            // First prime
  limit( lst ) ,            // Last Prime
  cg( fst ) ,               // CandidateGenerator
  range( lst - fst )  ,     // Range (not count) of primes
  primeCount(0) ,           // Primes generated 
  candidateCount(0)         // Candidates processed
{ 
  if ( fst >= lst )
    throw Range( "PrimeGenerator::PrimeGenerator() ;  first > last" ) ;
} 

Prime PrimeGenerator::get( )    // Filter non-primes from candidate generator
{ 
  PrimeRange candidate ;

  while ( true )
  {
    candidate = cg.next() ;       // Get prime candidate, 
                                  //   ends in 1, 3, 7 ,9
   
    if ( candidate > limit )      // Finished (not error)
      throw EndOfFile( "PrimeGenerator::get( ): Prime candidate > limit" ) ;

    candidateCount++ ;

    if ( !pv.isPrime( candidate ) )   // If not prime, get another candidate
      continue ;
  
    primeCount++ ;
    return candidate ;                // Prime, return
  }   // End  while 
}

