// PrimeFloatVector.hpp -- Source of primes for Goldbach test.
// Goldbach searches for primes working backward from the current 
// candidate sum. The search seldom requires more than a few
// hundred requests.
// When the request exceeds the last prime stored, the bottom 
// half of the vector is discarded
//    erase( begin() , begin() + (size()/2) ) ;
// and the top half is repopulated from the primec files.

#include "Prime.hpp"                // typedefs, exceptions
#include "DirectoryPrimeC.hpp"      // Class DirectoryPrimeC
#include <vector>
  using namespace std ;

typedef vector<Prime>::iterator vpi ;  

class PrimeFloatVector : public vector<Prime>
{
private:
  DirectoryPrimeC dpc ;         // Source of primes--directory of primec files

public:

  PrimeFloatVector( const string& dpcName , Prime low ) ;

  void reload() ;               // Dump bottom of vector, repopulate top

  vpi  previous( PrimeRange v ) ;  // Return iterator to prime preceding v
} ;
