// PrimeFloatVector.cpp -- 2018-09-21
// Provide source of primes to Goldbach program
// Beginning with prime previous to Goldbach even candidate,
// work downward for pair element.

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                 // Microsoft Boilerplate
#include "Prime.hpp"                // typedefs. exceptions
#include "PrimeFloatVector.hpp"     // Class PrimeFloatVector
#include "Progress.hpp"             // Class Progress
#include "ostreamFork.hpp"          // Class ostreamFork
#include <algorithm>                // upper_bound()
  using namespace std ;

const static offset vecSize( 50000000 ) ;  // 50 Million primes
      static Progress p( 10.0 ) ;          // Report ecery 10 seconds

  PrimeFloatVector::PrimeFloatVector( const string& dpcName , 
                                      Prime fst  ) 
  : dpc( dpcName ) 
  {                                   // Load vector
    reserve( vecSize ) ;              // Avoid reallocations

    while ( size() < capacity() )     // Copy values from PrimceC file to vector
    {
      Prime v = dpc.get() ;           // Get prime from PrimeC file
      push_back( v ) ;                // Append to vector
      if ( p.go() )                   // Progress report
        cout_cerr << "PrimeFloatVector stored: " << v << "  \r" ;
    }
    cout << endl ;
  }
                                      // Delete first half of vector and
  void PrimeFloatVector::reload()     // append new values to the end
  {
    erase( begin() , begin() + (size()/2) ) ;   // Delete beginning 1/2
    cout_cerr << endl ;
    while ( size() < capacity() )     // Copy values from PrimceC file to vector
    {
      Prime v = dpc.get() ;           // Get prime from PrimeC file
      push_back( v ) ;                // Append to vector
      if ( p.go() )                   // Progress report
        cout_cerr << "PrimeFloatVector reloading: " << v << "  \r" ;
    }
    cout_cerr << endl ;
  }
    
                                      // Return interator of prime before v
  vpi PrimeFloatVector::previous( PrimeRange v ) 
  {
    vpi i = upper_bound( begin() , end(), v ) ;   // First value greater than v

    if ( i == begin() )
      throw TooSmall( "PrimeFloatVector::getPrevious( v ): " , v ) ;

    if ( i == end() )                            // v too big
    {                                            // Dump small values
      reload() ;                                 // Dump lower 1/2 and append new primes
      i = upper_bound( begin() , end(), v ) ;    // First value greater than v
    } 

    i-- ;                                        // First value less than v

    return i ;
  }

 
