// PrimeCFileWriter.hpp -- Write PrimeCVector as file -- 2019-09-14

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef PRIMECFILEWRITER_HPP
#define PRIMECFILEWRITER_HPP

#include "PrimeCVector.hpp"               // Class PrimeCVector
#include "PrimeCArray.hpp"                // Class PrimeCArray
#include <fstream>                        // Class fstream
  using namespace std ;

class PrimeCFileWriter : public PrimeCVector
{
private:
  fstream    cFile ;                      // PrimeC (compact) file
  string     fileName ;                   // PrimeC file name
  PrimeCVector::iterator getIteratorP ;   // Location of getPrime() value

public:                                   // Create new blank PrimeC file
                                          // Limits rounded to multiple of 20
  PrimeCFileWriter( PrimeRange first ,    // First value (rounded down)
                    PrimeRange last ) ;   // Last value (rounded up)

  ~PrimeCFileWriter() ;         // Destructor: write check sum, close, set read only

  PrimeRange computeSum() ;               // Return value of check sum
  void computeCheck() ;                   // Set check sum
  void verifyCheck() ;                    // Compare computed sum to file value
                 
  Prime getPrime() ;                      // Return prime and move iterator

  void operator=( PrimeCArray& pcf ) ;    // Copy array to file

  virtual FlagByte getByte( const offset off ) ;   // Fetch byte from file

  virtual void     putByte( const offset off ,     // Store byte into file
                            const FlagByte c ) ;

} ;

#endif