// PrimeCFileReader.hpp -- PrimeCVector as input (read only) file -- 2018-09-14

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef PRIMECFILEREADER_HPP
#define PRIMECFILEREADER_HPP

#include "PrimeCVector.hpp"               // Class PrimeCVector
#include <fstream>                        // Class fstream
  using namespace std ;

class PrimeCArray ;          // Forward declaration (#include causes loop)

class PrimeCFileReader : public PrimeCVector    // Read from file
{
public:
  fstream    cFile ;                      // PrimeC (compact) file
  string     fileName ;                   // PrimeC file name
  PrimeCVector::iterator getIteratorP ;   // Location of getPrime() value

public:                                   // Create new blank PrimeC file
 
  PrimeCFileReader( const string& fileName ) ;  // Use previously generated primeC file

                                          // Find prime at or following v
  PrimeCVector::iterator  findPrime( const PrimeRange v ) ;

  Prime getPrime() ;                      // Return prime and move iterator

  virtual FlagByte getByte( const offset off ) ;   // Fetch byte from file

  virtual void     putByte( const offset off ,     // Store byte into file
                            const FlagByte c ) ;
} ;

#endif