// PrimeCFileReader.cpp -- Interface to primec (Compact) prime files.
//                         2018-09-13

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                // Microsoft Boilerplate
#include "PrimeCFileReader.hpp"    // Class PrimeCFileReader
#include "PrimeCArray.hpp"         // Class PrimeCArray
#include "SystemUtilities.hpp"     // setReadOnly()  limitsToFilename()
#include "Progress.hpp"

const static PrimeRange 
  headerLength( 3 * sizeof(PrimeRange) ) ;

PrimeCFileReader::PrimeCFileReader( const string& fn )
: fileName( fn )  
{
  string extension = fileExtFromPath( fn ) ;
  if ( extension != "primec" )
    throw FileError( "PrimeCFile() file extension not primec" ) ;

  cFile.open( fileName , ios::in + ios::binary ) ;    // Input only
  if ( ! cFile.good() )
    throw FileError( "PrimeCFile() file open error: " + fileName ) ;

  PrimeRange fst , lst , chk  ;                // Read and store limits

  cFile.seekg( 0 ) ;
  cFile.read( (char*)(&fst) , sizeof(fst) ) ;  // Start of series
  cFile.read( (char*)(&lst) , sizeof(lst) ) ;  // End of series
  cFile.read( (char*)(&chk) , sizeof(chk) ) ;  // Check value  

                        // Store in PrimeCVector protected members
  firstValue = fst ;                
  lastValue  = lst ;
  len = (lastValue - firstValue) / 20  ;   
  sum        = chk ;
//  verifyCheck() ;     // User choice
               
  getIteratorP = findNextPrime( fst ) ;  // getPrime() iterator to first prime
}

Prime PrimeCFileReader::getPrime() 
{
  Prime v = *getIteratorP ;        // Return current iterator target
  getIteratorP++ ;                 // Move to next prime
  return v ;
}


FlagByte PrimeCFileReader::getByte( const offset off ) 
{
  static FlagByte c ;
  cFile.seekg( off + headerLength ) ;
  cFile.read( (char*)(&c) , 1 ) ;
  if ( ! cFile.good() )
     throw FileError( "PrimeCFile() file read error" ) ;
  return c ;
}

void PrimeCFileReader::putByte( const offset off , const FlagByte c ) 
{
  throw FileError( "PrimeCFileReader::putByte() should not be called" ) ;

//  cFile.seekp( off + headerLength ) ;
//  cFile.write( (char*)(&c) , 1 ) ;
//  if ( ! cFile.good() )
//    throw FileError( "PrimeCFile() file write error" ) ;
}


