// PrimeCArray.hpp -- PrimeCVector as char array -- 2018-09-21

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef PRIMECARRAY_HPP
#define PRIMECARRAY_HPP

#include <numeric>                              // accumulate()
  using namespace std ;
#include "PrimeCVector.hpp"                     // Class PrimeCVector

class PrimeCFileReader ;                        // Forward declaration

                          // PrimeCVector as char array, for performance
class PrimeCArray : public PrimeCVector
{
private:
  unsigned char* compactArray ;   // PrimeC data, candidate prime or not
  offset         arraySz ;        // compactArray size

public:
  PrimeCArray( PrimeRange first , PrimeRange last ) ;

  PrimeCArray( PrimeCFileReader& pcfr ) ;   // Initialize array from file

  PrimeCArray( )                  // Default constructor
  : compactArray(0) ,             // Invalid object
    arraySz( 0 )
  { }


  void getArray( PrimeRange len ) ;      // Allocate PrimeCArray buffer 

                                  // Reset PrimeCArray, avoid destroy/construct
  void newRange( PrimeRange first , PrimeRange last ) ;

                                  // Copy primeC data from file
  void operator=( PrimeCFileReader& source ) ;

  unsigned char* arrayPointer()        // Location of PrimeC data
  {
    return compactArray ;
  }

  void computeCheck()            // Performance overload
  {
    sum = accumulate( compactArray , compactArray + length() , 0 ) ;
  } 

  void verifyCheck()             // Performance overload
  {
    PrimeRange s = accumulate( compactArray , compactArray + length() , 0 ) ;
    if ( sum == s ) 
      return ;

    throw PrimeException( "PrimeCArray::verifyCheck() error" ) ;
  }

  virtual FlagByte getByte( const offset off )    // Fetch byte from array
  {
    return compactArray[ off ] ;
  }

  virtual void putByte( const offset off ,       // Store byte into array
                        const FlagByte c ) 
  {
    compactArray[ off ] = c ;
  }

} ;

#endif