// PrimeCArray.cpp -- PrimeCVector as char array -- 2018-09-14

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                      // Microsoft Boilerplate
#include "PrimeCVector.hpp"              // Class PrimeCVector
#include "PrimeCFileReader.hpp"          // Class PrimeCFileReader
#include "PrimeCArray.hpp"               // Class PrimeCArray

                    // PrimeCVector as char array, for performance

void PrimeCArray::getArray( PrimeRange len )   // Allocate PrimeCArray buffer 
{                                              //  and zero it out
  unsigned char* arr = 0 ;
  arraySz = (size_t)(len) ;

  try
  {
    arr = new unsigned char[ arraySz ] ;  // Allocate array
  }
  catch( exception ex )
  {
    throw TooBig( "PrimeCArray(): memory fault" ) ;
  } ;
 
  compactArray = arr ;         // PrimeCArray 
  memset( compactArray, 0, arraySz ) ;    // Zero out array
}

                               // Copy data from file to new PrimeCArray
  PrimeCArray::PrimeCArray( PrimeCFileReader& pcfr )  // Constructor
  : PrimeCVector( pcfr.first() , pcfr.last() )        // Copy range from file
  {
    getArray( length() ) ;                  // Allocate array
    *this = pcfr ;                          // Copy file to array (*this)
  }

                                // Create without data (all zeros)
  PrimeCArray::PrimeCArray( PrimeRange first , PrimeRange last )
  : PrimeCVector( first , last )  
  { 
    if ( length() >= SIZE_MAX )             // 2^32
      throw TooBig( "PrimeCArray() array too big" ) ;

    getArray( length() ) ;                  // Allocate array
  }

                                            // Reuse existing char array
  void PrimeCArray::newRange( PrimeRange first , 
                              PrimeRange last ) 
  {
    offset asz = (offset)((last-first)/20) ;    // New array size

    if ( arraySz < asz )              // Larger than current array
    {                                 // Yes, allocate larger array
      delete compactArray ;       
      getArray( asz ) ;
    }

    init( first ,  last ) ;                // Set metadata 
  }

                                 // Copy primeC data from file
  void PrimeCArray::operator=( PrimeCFileReader& source )
  {   
    PrimeRange fst , lst, chk ;               // Read temp
    source.cFile.seekg( 0 ) ;
                                 // Get first value in file
    source.cFile.read( (char*)(&fst) , sizeof(fst) ) ;  
                                 // Get last value in file
    source.cFile.read( (char*)(&lst) , sizeof(lst) ) ;  
                                 // Get chck value (sum of data byres)
    source.cFile.read( (char*)(&chk) , sizeof(chk) ) ;  // Check value 

    newRange( fst , lst ) ;  

    sum = chk ;                     
                                               // Copy file to array
    source.cFile.read( (char*)(compactArray) , source.length() ) ;

    if ( !source.cFile.good() )
      throw PrimeException( "PrimeCArray::operator=() : Read error" ) ;
  }
