                           // Prime.hpp -- 2018-09-21
                           // Declarations, typedefs and utilities 

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef PRIME_HPP
#define PRIME_HPP

#include <string>          // Class string
#include <iostream>        // cout,  endl,  imbue(), locale()
#include <thread>          // Class thread
  using namespace std ;

                       // 0 to 18,446,744,073,709,551,615  (2**64 - 1)
typedef unsigned long long PrimeRange ;  // May not be prime
typedef unsigned long long Prime ;       // Theoretically prime 

const Prime      LargestPrime( 18446744073709551557 ) ;
const PrimeRange Largest32bit( _UI32_MAX ) ;
const Prime      Largest32bitPrime( 4294967291 ) ;

typedef size_t offset ;                       // File byte location

inline void showCommas( ostream& os = cout )  // Display integers as
{                                             // 123,456,789
  os.imbue( std::locale("") ) ;  
}

template<typename num> string str( num v )    // Numeric to string
{
  return std::to_string( v ) ;
}
 
inline void pause()                           // Wait for user 
{
  cout << "\nPress ENTER to continue." ;
  char c ;
  cin.get(c) ;
}

inline void wait( double t = 1.0 )   // Pause execution for t seconds
{
  long ltime = (long)(t * 1000) ;
  std::this_thread::sleep_for(std::chrono::milliseconds(ltime));
}

                                // Exceptions for Prime library
class PrimeException : public exception
{
private:
  const string text ;

public:
  PrimeException( const string& t = "PrimeException")  
  : text(t)
  {}

  PrimeException( const string& t , const PrimeRange v )  
  : text( t + str( v ) )
  {}

  const char* what() const         // class exception overload
  {
    return text.c_str() ;
  }
} ;

////////////////////////////////////

class Range : public PrimeException        // Value out of range
{
public:
  Range( const string& t = "Range Error" )    // Just message
  : PrimeException( t )
  {}

  Range( const string& t , const PrimeRange v )  // Message with value
  : PrimeException( t + ":  " + str( v ) )
  {}
} ;

////////////////////////////////////

class TooSmall : public Range  
{
public:                                              // Just message
  TooSmall( const string& t = "Range Error, too small" )
  : Range( t )
  {}

  TooSmall( const string& t , const PrimeRange v )   // Message with value
  : Range( t + ":  " + str( v ) )
  {}
} ;

////////////////////////////////////

class TooBig : public Range 
{
public:                                             // Just message
  TooBig( const string& t = "Range Error, too big" )
  : Range( t )
  {}

  TooBig( const string& t , const PrimeRange v )    // Message with value
  : Range( t + ":  " + str( v ) )
  {}
} ;

////////////////////////////////////

class EndOfFile : public PrimeException          // Not necessarily error
{
public:
  EndOfFile( const string& t = "End of file" )
  : PrimeException( t )
  {}
} ;

////////////////////////////////////

class FileError : public PrimeException     
{
public:
  FileError( const string& t = "File Error" , const string& fn = "" )
  : PrimeException( t + ": " + fn )
  {}

} ;
#endif