// MicroWatch.hpp  -- Microsecond timer -- 2018-09-10

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef MICROWATCH_HPP
#define MICROWATCH_HPP

#include <Winbase.h> 
  //  LARGE_INTEGER
  //  void QueryPerformanceFrequency( &frequency ) ;
  //  BOOL WINAPI QueryPerformanceCounter( _Out_ LARGE_INTEGER *lpPerformanceCount );

class MicroWatch                // Measure micosecond intervals
{
private:
  LARGE_INTEGER begin ;           
  LARGE_INTEGER frequency ;

public:
  MicroWatch()                                 // Constructor
  {
    QueryPerformanceFrequency( &frequency ) ;  // Clicks per second
    start() ;                                  // Start timer
  }

  void start()
  {
    QueryPerformanceCounter( &begin ) ;        // Start timer
  }

  double interval()                     // Interval in seconds since start()
  {
    LARGE_INTEGER 
      now ,                             // Current time
      ElapsedMicroseconds ;             // Time since start()

    QueryPerformanceCounter( &now ) ;
    ElapsedMicroseconds.QuadPart = now.QuadPart - begin.QuadPart;

    ElapsedMicroseconds.QuadPart *= 1000000;
    return (double)(ElapsedMicroseconds.QuadPart) / (double)(frequency.QuadPart) ;
  }

} ;

#endif