// Distribution.hpp -- Creates and list distribution of values

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef DISTRIBUTION_HPP
#define DISTRIBUTION_HPP

#include <map>                  // Map template
   using namespace std ;

                     // Map of factors to occurence count
template < typename KeyT , typename CountT >
class Distribution : public map< KeyT , CountT >
{
public:
  void increment( KeyT k )                         // Increment count of k's
  {
     auto i = find( k ) ;                          // k already in map?
     if ( i == end() )                              
       insert( std::pair<KeyT,long>( k , 1 ) ) ;   // No, insert it
     else
       ( i->second )++ ;                           // Yes, increment count
  }

  void list( ostream& os )                         // Dump distribution to os
  {
    long total( 0 ) ;                              // Total of all occurances
    os << "Key      Occurances  Total Occcurances\n" ;
    for ( auto i = begin() ; i != end() ; i++ )
    { 
      total += i->second ;                         // Increment total occurences

  // File  Key(factor)     Occurances of Factor    All occurances
      os << i->first << "   " << i->second << "   " << total << endl ;
    }
  }

} ;

#endif