// DirectoryStream.hpp -- Template for sequential stream 
// extraction from files

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef DIRECTORYSTREAM_HPP
#define DIRECTORYSTREAM_HPP

#include <fstream>                   // Class ifstream
  using namespace std ;
#include "Directory.hpp"             // Class Directory
#include "Prime.hpp"                 // Typedefs
#include "OstreamFork.hpp"           // Class ostreamFork

typedef vector<string>::iterator fnameItr ;

template<class Data>              // Data is type to be extracted
class DirectoryStream
{
private:
  Directory dir ;                       // Vector of file names
  string    dirName ;                   // Name of directory
  fnameItr  fileNameItr ;               // Pointer to current file name
  ifstream  txtFile ;                   // Text file in process

public:
  DirectoryStream( const string& dn )   // Constructor
  : dir( dn ) ,                         // Vector of file names
    dirName( dn ) ,                     // Name of directory
    fileNameItr( dir.begin() ) ,        // Point to first file name
    txtFile( *fileNameItr , ios::in )   // Open file for input
  {
    if ( !txtFile.good() )
      throw FileError( "PrimeDirectory() : File open error : " 
                       + *fileNameItr ) ;

    cout_cerr << "Reading: " << *fileNameItr << endl ;    // Progress report
  }

  bool checkEOF()              
  {
    if ( txtFile.eof() )         // If end of file
    {
      next() ;                   // Move to next file
      return true ;              // Yes it was EOF
    }    
    
    return false ;               // Not EOF, continue normally
  }

  Data get()                     // Return next data item
  {
    Data v ;
    txtFile >> v ;               // Extract data form file
    if ( checkEOF() )            // If EOF , next file was opened
      txtFile >> v ;             // Try again

    if ( !txtFile.good() )
        throw FileError( "PrimeDirectory::get() : File read error : " ) ;

    return v ;
  }

  void next()                          // Move to next input file
  {
    txtFile.close() ;                  // Close current file
    fileNameItr++ ;                    // Move to next input file name
    if ( fileNameItr == dir.end() )    // End of directory file name list?
      throw EndOfFile( "PrimeDirectory EOF" ) ;     // Yes

    txtFile.open( *fileNameItr , ios::in ) ;        // Open next file
    if ( !txtFile.good() )
      throw FileError( "PrimeDirectory() : File open error : " 
                       + *fileNameItr ) ;
                       
    cout_cerr << "Reading: " << *fileNameItr << endl ;   // Progress report
  }
} ;

#endif