// DirectoryPrimeC.hpp -- Process collection of PrimeCFile objects
// as a continuous file. -- 2018-09-14

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef DIRECTORYPRIMEC_HPP
#define DIRECTORYPRIMEC_HPP

#include "PrimeCFileReader.hpp"    // Class PrimeCFileReader
#include "Directory.hpp"           // Class Directory
#include "Prime.hpp"               // Typedefs, exception, etc
#include <string>                  // Class string
#include <iostream>                // cout
#include <sstream>                 // Class stringstream
  using namespace std ;

typedef vector<string>::iterator fnameItr ;

class DirectoryPrimeC       // Collection of PrimeC files as one continuous file
{
private:
  Directory   dir ;              // Contained file list
  string      dirName ;          // Directory name
  fnameItr    fileNameItr ;      // Iterator to current file name
  PrimeCFileReader* pcFile ;     // Pointer to current PrimeCFile file object

public:
  DirectoryPrimeC( const string& dn )        // Constructor
  : dir( dn ) ,                              // Directory (list of file names)
    dirName( dn ) ,                          // Directory name
    fileNameItr( dir.begin() ) ,             // Iterator to current file name     
    pcFile( new PrimeCFileReader( *fileNameItr ) )  // Pointer to current PrimeC file
  {
    cout << "Reading: " << *fileNameItr << endl ;   // Progress report
  }

  void findFile( PrimeRange v )
  {
    fnameItr fn( dir.begin() ) ;
    stringstream fname( *fn ) ;
    PrimeRange fst , lst ;
    char to[4] ;
    while( true )
    {
      fname >> fst ;
      fname.get( to , 3 ) ;
      fname >> lst ;
      if ( (fst <= v) & (v <= lst) )    // v in this file?
        break ;                        // Yes

      fn++ ;                        // Go to next file (EOF exception)
      if ( fn == dir.end() )   // Last file in directory?
        throw EndOfFile( "End of PrimeC directory: " + dirName ) ;
    }

    delete pcFile ;              // Close current PrimeC file 
    pcFile = new PrimeCFileReader( *fn ) ;   // Open next file
  }

  Prime get()                      // Get a prime
  {
    Prime v ;                      // Prime value to return

    try
    {
      v = pcFile->getPrime() ;     // Get prime from PrimeC file
    }
    catch( EndOfFile ex )          // If End of current PrimeC file
    {
      delete pcFile ;              // Close current PrimeC file
      fileNameItr++ ;              // Move to next file name

      if ( fileNameItr == dir.end() )   // Last file in directory?
        throw EndOfFile( "End of PrimeC directory: " + dirName ) ;

      pcFile = new PrimeCFileReader( *fileNameItr ) ;   // Open next file
      v = pcFile->getPrime() ;                          // Get prime from new file
    }                              // Possible exception (open error)
 
     return v ;                    // Get prime from new file
  }

} ;

#endif