// Directory.cpp --  2018-09-21
//                  vector<string> containing file names in directory

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                // Microsoft Boilerplate
#include "Directory.hpp"           // Class Directory
#include "SystemUtilities.hpp"     // execute(), deleteFile()
#include <windows.h>               // GetTempPath()  TCHAR
#include <fstream>                 // ifstream  remove()
  using namespace std; 

 Directory::Directory( const string& dir )     // Constructor
 : dirName( dir ) 
 {
   load( dir ) ;            // Load directory list into vector
 }

                            // Get directory file names from DOS dir 
 void Directory::load( const string& dir )
 {     
   string tempFile = getTempDirectory() + "directory.dirlst" ;

   deleteFile( tempFile ) ;              // Delete temp file, if any
          
   // DOS dir command with only file names redirected to temp file
   //  /B     -- Bare format, names and extensions only
   //  /A-D   -- No nested directories
   //  /O:N   -- Alphabetical order
   // First line: with escape character '\'
   // Second line: visual rendering

// dir /B /A-D /O:N \"C:\\Primes\\0to4G_txt\\*.*\" > C:\\Temp\\directory.dirlst
// dir /B /A-D /O:N  "C:\Primes\0to4G_txt\*.*"     > C:\Temp\directory.dirlst

   string cmd = "dir /B /A-D /O:N \"" + dir + "\\*.* \" > " + tempFile ;
   execute( cmd ) ;                // Run DOS command

   ifstream fn( tempFile ) ;       // Directory list from DOS dir command        
   if ( !fn.good() )
     throw runtime_error( "Directory() temp not opened" ) ;

   string fileName ,               // File name only
          fullName ;               // Fullpath name

   getline( fn , fileName ) ;      // Get file name; blanks in name OK

   while ( !fn.eof() )
   {
     fullName = dirName + "\\" + fileName ;
     push_back( fullName ) ;       // Add to this->vector
     getline( fn , fileName ) ;    // Get file name; blanks in name OK
   }

   deleteFile( tempFile ) ;        // Delete temp file 
 }
 
