 // CandidateGenerator.hpp   --  2018-09-24
 // Generate candidate for prime value beginning with "first"
 // 2, 3, 5, 7, 11 ...  then only numbers ending in 1, 3, 7, 9

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#ifndef CANDIDATEGENERATOR_HPP
#define CANDIDATEGENERATOR_HPP

#include "Prime.hpp"                // PrimeRange typedef

class CandidateGenerator
{
private:
  PrimeRange tens   ;               // Next 10*(prime/10) 
  int        units  ;               // Next prime%10
  void  increment() ;               // Move to next candidate
public:
  CandidateGenerator( const PrimeRange first ) ;  // First candidate >= first

  PrimeRange next() ;              // Return current candidate,  calculate next
 
  void start( const PrimeRange first ) ;    // Restart generator at first
} ;

#endif