// CandidateGenerator.cpp -- Generate values ending in 1, 3, 7, 9 -- 2018-09-14

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                    // Microsoft Boilerplate
#include "Prime.hpp"                   // Typedefs
#include "CandidateGenerator.hpp"      // Class CandidateGenerator

// Generate candidates for prime value beginning with "first"
// 2, 3, 5, 7, 11 ...  then only numbers ending in 1, 3, 7, 9

void  CandidateGenerator::start( const PrimeRange first )   // Initialize generator
{
  if ( first <= 7 )                        // Special cases for small values
  {                // 0 1 2 3 4 5 6 7 
    const int s[] = { 2,2,2,3,7,7,7,7 } ;  // Adjust to next prime
    units = s[ first ] ;
    tens  = 0 ;
    return ;
  }

  if ( first < 12 )                        //  8 <= first <= 11
  {
    tens  = 10 ;
    units = 1 ;
    return ;
  }
                                        //  first >= 12
  tens = 10 * (first/10) ;              // Round down to multiple of 10
           
                 // 0 1 2 3 4 5 6 7 8 9
  const int s[] = { 1,1,3,3,7,7,7,7,9,9 } ;   // Discard 0, 2, 4, 5, 6, 8

  units = s[ first % 10 ] ;             // Adjust to next candidate
}

                                        // Constructor
CandidateGenerator::CandidateGenerator( const PrimeRange first ) 
{
  start( first ) ;
}

void  CandidateGenerator::increment()     // Next candidate
{
  const static int next_unit[] = 
      //  0  1  2  3  4  5  6  7  8  9
        { 0, 3, 0, 7, 0, 0, 0, 9, 0, 1 } ;

  if ( 0 == tens )             // candidate < 11
    throw PrimeException( "Prime CandidateGenerator::increment()  error" ) ;

  if ( units == 9 )
    tens+=10 ;

  units = next_unit[ units ] ;          // 1, 3, 7, 9, 1, 3 ..
}

Prime CandidateGenerator::next()        // Deliver "good" candidate and 
{                                       // move to next candidate
  
  PrimeRange cand = tens + units ;      // Candidate delivered on this call

  if ( cand > LargestPrime )
    throw EndOfFile( "CandidateGenerator::next() : last candidate" ) ;

  if ( cand >= 11  )
  {
    increment() ;                       // Ready for next call
                                        // Discard multiples of 3 or 7
    while( (0 == cand % 3) | (0 == cand % 7) )     // 11/18 speedup
    {
      cand = tens + units ;      // Return value 
      increment() ;              // Next candidate   
    }

     return cand ;
   }  // End if ( cand >= 11  )
 
                                    
  if ( cand == 7 )                      // 11 follows 7
  {
    units = 1 ;
    tens = 10 ;
    return cand ;
  }
  
  if ( cand < 7 )                        // 2, 3, 5
  {                  //     2  3     5
    const int s[] = { 0, 0, 3, 5, 0, 7  } ;       
    units = s[ cand ] ;
    tens = 0 ;
    return cand ;
  }

  throw PrimeException( "Prime CandidateGenerator::next()  error" ) ;
}
