// TxtToTxt.cpp : Copy txt to new txt

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                // Microsoft Boilerplate
#include <string>                  // Class string
#include <fstream>                 // Class fstream
  using namespace std ;
#include "Prime.hpp"               // Typedef, inline utilities, exceptions
#include "DirectoryStream.hpp"     // Class DirectoryStream
#include "Progress.hpp"            // Class Progress (report timer)
#include "Common.hpp"              // limitsToFilename()
#include "OstreamFork.hpp"       // Class ostreamFork

int main( int argc , char* argv[] )
{
//  ostreamFork report( cout , cerr ) ;

  showCommas( cout ) ;
  showCommas( cerr ) ;

  if ( argc != 4 )
  {
    cout << "TxtToTxt TxtDirectory start end\n"
           << "start >=2 , end > start" << endl ;
    return 1 ;
  }

  string directoryName( argv[1] ) ,
         startTxt(      argv[2] ) ,
         endTxt(        argv[3] ) ;

  PrimeRange start ,
             end   ; 

  try
  {
    start = stoull( startTxt ) ;
    end   = stoull( endTxt   ) ;
  }
  catch( exception ex )
  {
    cout << "Start or end conversion error." << endl ;
    pause() ;
    return 2 ;
  }

  try
  {
    string newTxtName = limitsToFilename( start ,  end ) + ".txt" ;
    ofstream newTxt( newTxtName ) ;

    DirectoryStream<Prime> primeStream( directoryName ) ;

    Prime    v = 0 ;
    Progress p( 2.0 , 0 ) ;     // 5 second report cycle

    do                          // Skip files to start
    {
      v = primeStream.get() ;   // Get a txt prime

      if ( p.go() )
        cout << "Skipping: " << v << endl ;

      if ( start > (v + 300000000) )
        primeStream.next() ;         
    }
    while ( v < start ) ;       // Skip to start

    while ( true )
    {
      if ( v > end ) 
        return 0 ;
          
      newTxt << v << endl ;             // Store in new txt file

      if ( p.go() )
        cout << "Copied: " << v << endl ;

      v = primeStream.get() ;    // Get a txt prime
    }
  }
  catch( EndOfFile ex )      // Normal End
  {
    return 0 ;
  } 
  catch( exception ex )
  {
    cout << ex.what() << endl ;
    pause() ;
    return 1 ;
  }
 
  cout << "Abnormal exit." ;
	return 2 ;
}

