// TestPrimeC.cpp : Test PrimeC files -- 2018-09-14
// Compare primeC files with Primeo txt files
// DirectoryStream and DirectoryPrimeC classes treats contained 
// files as one continuous file.

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"               // Microsoft boilerplate
#include <string>                 // Class string
#include <fstream>                // Class ifstream
  using namespace std ;
#include "Prime.hpp"              // Typedefs, exception, etc
#include "DirectoryStream.hpp"    // Class DirectoryStream
#include "Progress.hpp"           // Class Progress (report timing)
#include "StopWatch.hpp"          // Class StopWatch 
#include "DirectoryPrimeC.hpp"    // Class DirectoryPrimeC
#include "OstreamFork.hpp"        // c;ass ostreamFork, cout_cerr

int main( int argc , char* argv[] )
{
  ofstream reportFile( "PrimecCheck.txt" ) ;
  cout_cerr.setStream( cout , reportFile ) ;

  showCommas( cout ) ;            // Display integers with commas
  showCommas( reportFile ) ; 

  if ( argc != 3 )
  {
    cout_cerr << "TestPrimeC txtDirectory PrimeCDirectory\n" << endl ;
    return 1 ;
  }

  string txtDirectoryName(    argv[1] ) ,
         PrimeCdirectoryName( argv[2] ) ;

  Prime  sv = 0 ,              // Prime from txt stream
         cv = 0 ;              // Prime from compact stream

  try
  {
    DirectoryStream<Prime> psin( txtDirectoryName ) ;
    DirectoryPrimeC        pcin( PrimeCdirectoryName ) ;

    StopWatch sw ;
    Progress p( 20.0 ) ;       // 20 second report cycle

    while ( true )             // Exit on EOF exception (end of directory)
    {                          // Both get() bridge to next file, if any
       sv = psin.get() ;       // Get a txt prime   
       cv = pcin.get() ;       // Get a compact prime   
     
       if ( sv != cv )         // Prime values don't match?
       {
         cout_cerr << "Mismatch: " << sv << " , " << cv << endl ;
         pause() ;
       }

       if ( p.go() )           // Report progress periodically
         cout_cerr << "Compared: "   << sv
                   << "  Elapsed hours: "  
                   << sw.hours() << endl ;        
    }
  }
  catch( EndOfFile ex )        // Normal end
  {
    cout_cerr << ex.what() << endl ;
    cout_cerr << "txt = "      << sv
              << "  primeC = " << cv << endl ;
    pause() ; 
    return 0 ;
  }
  catch( PrimeException ex )
  {
    cout_cerr << ex.what() << endl ;
    pause() ;
    return 1 ;
  }


  catch( exception ex )
  {
    cout_cerr << ex.what() << endl ;
    pause() ;
    return 1 ;
  }
 
  cout_cerr << "Ended without exception." << endl ;
  pause() ;
	return 0 ;
}


