// RunTxtPrimeGen.cpp : Run prime generator 
// Split output into managable time slots

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"              // Microsoft boilerplate
#include "Prime.hpp"             // typedefs
#include "SystemUtilities.hpp"   // execute()
#include "ostreamFork.hpp"       // Class ostreamFork
#include <fstream>               // Class ofstream
  using namespace std;

const static long fileRange( 100000 ) ;    // 100000 takes about 5 hr near end


PrimeRange nextFirst( PrimeRange f )
{                                               // Next file start
  if ( LargestPrime - f < fileRange )           // Start too big?
    throw EndOfFile( "Beyond last prime" )  ;
  else
    return f + fileRange ;   
}

PrimeRange nextEnd( PrimeRange e )   
{   // LargestPrime     < e + fileRange                                      // Next file end
  if ( LargestPrime - e < fileRange )     // End too big
    return  LargestPrime + 1 ;            // Stop before overflow
  else
    return  e + fileRange ;
}
  
int main( int argc , char* argv[] )
{
  ofstream report( "RunTxtPrimeGen.report" ) ;
  cout_cerr.setStream( cout , report );

  if ( argc != 3 )
  {
    cout_cerr << "RunTxtPrimeGen start end" << endl ;
    return 1 ;
  }

  string sstart( argv[1] ) ,        // Starting value 
         send(   argv[2] ) ;        // Ending value

  PrimeRange start ,
             end ;
  try
  {
    deleteChar( sstart , ',' ) ;    // Permit commas --  123,456,789
    deleteChar( send   , ',' ) ;
    start = stoull( sstart ) ;      // First prime
    end   = stoull( send   ) ;      // Last prime
  }
  catch( exception ex )
  {
    cout_cerr << "Conversion error: " << sstart 
              << ", " << send << endl ;
    return 1 ;
  }

  try
  {
    PrimeRange fileStart( start ),                  // Start of current file
               fileEnd( nextEnd( fileStart ) ) ;    // End of current file

    string command  ,
           startCmd ; 

    while( fileEnd <= end && fileStart < LargestPrime )  
    {      
      command = "BuildTxtPrime "                  // DOS command
                 + str( fileStart ) 
                 + "  " + str( fileEnd );
      startCmd = "start \"" + command + "\"" ;     // Start + title ;
      startCmd += " /LOW " + command ;
      cout_cerr << "Running: " << command << endl ;
      cout << startCmd << endl ;
      execute( command ) ;                           // Exception on error
               
      fileStart = nextFirst( fileStart ) ;          // Exception 
      fileEnd   = nextEnd( fileEnd ) ;    
    }
  }
  catch( EndOfFile ex )   // Not error
  { }

  cout_cerr << "Last file done." << endl ;
	return 0 ;
}
