// RunTxtPrimeGen.cpp : Run prime generator 
// Split output into managable time slots

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"              // Microsoft boilerplate
#include "Prime.hpp"             // typedefs
#include "SystemUtilities.hpp"   // execute()
#include "ostreamFork.hpp"       // Class ostreamFork
#include <fstream>               // Class ofstream
  using namespace std;

PrimeRange nextFirst( PrimeRange f , PrimeRange fileRange )
{                                               // Next file start
  if ( LargestPrime - f < fileRange )           // Start too big?
    throw EndOfFile( "Beyond last prime" )  ;
  else
    return f + fileRange ;   
}

PrimeRange nextEnd( PrimeRange e  , PrimeRange fileRange )   
{   // LargestPrime     < e + fileRange                                      // Next file end
  if ( LargestPrime - e < fileRange )     // End too big
    return  LargestPrime + 1 ;            // Stop before overflow
  else
    return  e + fileRange ;
}
  
int main( int argc , char* argv[] )
{
  ofstream report( "RunTxtPrimeGen.report" ) ;
  cout_cerr.setStream( cout , report );            // Two report streams

  if ( argc != 4 )
  {
    cout_cerr << "RunTxtPrimeGen start end range" << endl ;
    return 1 ;
  }

  string sstart( argv[1] ) ,        // Starting value 
         send(   argv[2] ) ,        // Ending value
         srange( argv[3] ) ;        // Range per file

  PrimeRange start ,
             end   ,
             fileRange ;
  try
  {
    deleteChar( sstart , ',' ) ;    // Permit commas --  123,456,789
    deleteChar( send   , ',' ) ;
    deleteChar( srange , ',' ) ;

    start     = stoull( sstart ) ;  // First prime
    end       = stoull( send   ) ;  // Last prime
    fileRange = stoull( srange ) ;  // Individual file range
  }
  catch( exception ex )
  {
    cout_cerr << "Conversion error: " << sstart 
              << ", " << send << endl ;
    return 1 ;
  }

  try
  {
    PrimeRange fileStart( start ),                  // Start of current file
               fileEnd( nextEnd( fileStart , fileRange ) ) ;    // End of current file

    string command ;           // Command to run each BuildTxtPrime

    while( fileEnd <= end && fileStart < LargestPrime )  
    {      
      command = "BuildTxtPrime " + str( fileStart )   // Assemble command
                 + "  " + str( fileEnd );

      cout_cerr << "Running: " << command << endl ;   // Report progress
      execute( command ) ;                            // Exception on error
                                                      // BuildTxtPrime ended
                                                      // Prepare for next run
      fileStart = nextFirst( fileStart , fileRange) ;       // Exception on EOF
      fileEnd   = nextEnd( fileEnd , fileRange) ;    
    }
  }
  catch( EndOfFile ex )            // Not error
  { 
    cout_cerr << "Last file done." << endl ;
	  return 0 ;                     // Normal exit
  }
  catch( exception ex )            // Error
  {
    cout_cerr << ex.what() << endl ;
    pause() ;
    return 1 ;
  }
  
  cout_cerr << "Should not end here." << endl ;
  pause() ;
	return 1 ;
}
