// PrimeCheck.cpp: Test Prime files -- 2018-10-10
// Sanity check prime files.

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"               // Microsoft boilerplate
#include <string>                 // Class string
#include <fstream>                // Class ifstream
#include <vector>                 // Class vector
#include <map>                    // Class map
#include <cmath>                  // log()
  using namespace std ;
#include "Prime.hpp"              // Typedefs, exception, etc
#include "DirectoryStream.hpp"    // Class DirectoryStream
#include "Progress.hpp"           // Class Progress (report timing)
#include "StopWatch.hpp"          // Class StopWatch 
#include "DirectoryPrimeC.hpp"    // Class DirectoryPrimeC
#include "OstreamFork.hpp"        // class ostreamFork, cout_cerr

/*
class counter : public map< Prime , vector<Prime> >
{
public:
  typedef std::pair<Prime , vector<Prime> > mPair ;

  void increment( Prime delta ,  Prime v )
  {
    operator[](delta).push_back( v ) ;
  }
} ;
*/

int main( int argc , char* argv[] )
{
  ofstream reportFile( "PrimecCheck.txt" ) ;
  cout_cerr.setStream( cout , reportFile ) ;

  showCommas( cout ) ;            // Display integers with commas
  showCommas( reportFile ) ; 

  if ( argc != 3 )
  {
    cout_cerr << "TestPrimeC txtDirectory split_point" << endl ;
    return 1 ;
  }

  Prime  v = 0 ,             // Prime from txt stream
         previous = 0 ,
         delta = 0 ,
         count = 0 ;
  string txtDirectoryName( argv[1] )  ;
  string splitPointStr( argv[2] ) ;
  Prime  split = std::stoi( splitPointStr ) ;
  vector<PrimeRange> deltaList( 1001, 0 ) ;
  map< Prime , vector<Prime> > longDelta ;

  try
  {
    DirectoryStream<Prime> psin( txtDirectoryName ) ;

    StopWatch sw ;
    Progress p( 5.0 ) ;       // 5 second report cycle

    while ( true )             // Exit on EOF exception (end of directory)
    {                          // Both get() bridge to next file, if any
       v = psin.get() ;        // Get a txt prime   
       delta = v - previous ;
       previous = v  ;

       if ( 0 != count )
       {
         if ( (0 == v%2) && (2 != v) )
          throw PrimeException( "Value even: " , v ) ;
   
         if ( (1 == delta%2 ) && (3 != v))
          throw PrimeException( "Delta odd: " , v ) ;
       }
       
       count++ ;

       if ( delta < split )
         ++(deltaList[ delta ] ) ;          // Registewr count only
       else
       {
         longDelta[delta].push_back( v ) ;  // Register prime with delta
       }

       if ( p.go() )           // Report progress periodically
         cout_cerr << v
                   << "  Elapsed hours: "  
                   << sw.hours() << endl ;  
   //     if ( v > 50000000000 )
   //       throw EndOfFile() ;      
    }
  }
  catch( EndOfFile ex )        // Normal end
  {
    cout_cerr << "ln( " << v << " ) = " << log(v) << endl ;
    cout_cerr << "Small deltas" << endl ;
    for ( int i = 2 ; i < split ; i+=2 )
    {
      PrimeRange d =  deltaList[i] ;
      if ( 0 != d )
      {
        cout_cerr << i << " : " 
                  << d << "  " <<  endl ;
      }
    }

    cout_cerr << "\nBig deltas" << endl ;
    for ( auto i = longDelta.begin() ;  i != longDelta.end() ; i++ )
    {
      cout_cerr << i->first << " : " ;
      for ( auto j = (i->second).begin() ; j !=(i->second).end() ; j++ )
      {
        cout_cerr << *j << "  " ;
      }
      cout_cerr << endl ;
    }
    pause() ; 
    return 0 ;
  }
  catch( PrimeException ex )
  {
    cout_cerr << ex.what() << endl ;
    pause() ;
    return 1 ;
  }


  catch( exception ex )
  {
    cout_cerr << ex.what() << endl ;
    pause() ;
    return 1 ;
  }
 
  cout_cerr << "Ended without exception." << endl ;
  pause() ;
	return 0 ;
}
