// PrimeDtoTxt.cpp : Converts primed to txt.
// A primed file stores primes as deltas (difference) from previous prime.
// Delta is stored as 8 bit bytes equal to 1/2 the actual value,
// since the delta is always even, except for 2 to 3. 
// Three is thus the minimum start.
// The range of values in a file is defined by the file name, ie. 
//   3_to_1000.primed

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"
#include <string>
#include <fstream>
  using namespace std ;
#include "Prime.hpp"
#include "Directory.hpp"
#include "PrimeDfile.hpp"


int main( int argc , char* argv[] )
{
  if ( argc != 2 )
  {
    cout << "PrimeDtoTxt primed file" << endl ;
    return 1 ;
  }

  PrimeDin pdi( argv[1] ) ;
  Prime v ;

  try
  {
    while ( true )
    {
      v = pdi.get() ;
      cout << v << "  " ;
    }
  }
  catch( EndOfFile ex )
  {}

	return 0 ;
}

