// BuildTxtPrime.cpp : Build txt prime file. -- 2018-09-27

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                 // Microsoft boilerplate
#include "Prime.hpp"                // Typedefs, exceptions
#include "PrimeGeneratorC.hpp"      // PrimeGeneratorC
#include "StopWatch.hpp"            // StopWatch (timer)
#include "Progress.hpp"             // Progress report gate
#include "ostreamFork.hpp"          // Class ostreamFork
#include "SystemUtilities.hpp"      // deleteChar()
#include <fstream>                  // ofstream
#include <iomanip>                  // setprecision(5) 
#include <iostream>                 // cout
  using namespace std ;  

                                    // BuildTxtPrime firstPrime lastPrime
int main( int argc , char* argv[] )
{
  if ( argc != 3 )
  {
    cout << "BuildTxtPrime firstPrime lastPrime" << endl ;
    return 1 ;
  }
  
  string firstStr( argv[1] ) ,    // First prime
         lastStr(  argv[2] ) ;    // Last prime

  Prime  first  ,
         last   ;
  try
  {
    deleteChar( firstStr , ',' ) ;    // Permit commas --  123,456,789
    deleteChar( lastStr  , ',' ) ;
    first = stoull( firstStr ) ,      // Strin to Prime
    last  = stoull( lastStr  ) ;
  }
  catch( exception ex )
  {
    cout << "Conversion error : " 
         << firstStr << "  " << lastStr << endl ;
    pause() ;
    exit( 1 ) ;
  }

  if ( first >= last )
  {
    cout << "BuildTxtPrime first >= last" << endl ;
    return 1 ;
  }

  double range( (double)(last - first) ) ;   // Range (not count) of primes

  string fileName( limitsToFilename( first , last ) ) ;  // Standard file name
  ofstream report( fileName + ".report" ) ;
  cout_cerr.setStream( cout , report ) ;   
  showCommas( cout   ) ;                   // Show commas
  showCommas( report ) ; 

                                           // New Prime txt file
  ofstream pTxtFile( fileName + ".txt" , 
                     ios::out | ios::trunc )  ;    
  
  if ( !pTxtFile.good() )
    throw PrimeException( "BuildTxtPrime: Output file error" ) ;
 
  Prime v ;
  StopWatch sw ;                           // Timer

  try
  {
    cout_cerr << "Building PrimeGeneratorC" << endl ;
    PrimeGeneratorC pg( first , last ) ;

    cout_cerr << "Building " + fileName + ".txt" << endl ;

    Progress p( 5.0 ) ;     // Display progress every 5 second 

    do     // while ( v <= last ) ;
    {
      v = pg.get() ;                      // Get a prime

      pTxtFile << v << endl ;             // Write to file
           
      if ( p.go() )                       // Timer expired ?
      {                                   // Yes, report
        double age  = sw.hours() ;                   // Elapsed time
        double done = ( v - first ) / range ;        // Fraction finished
        double remaining = ( (age / done) - age ) ;  // Estimated Remaining time

        cout_cerr << v << " : "                      // Progreass message
             << std::setprecision(3)                 // 3 significant digits
             << done * 100.  << " % : hours " 
             << sw.hours()   << " elapsed :   "
             << remaining    << " remaining"  << endl ;    
 //          << " remaining       \r"  ;                 // No line feed
       }  // end  if ( p.go() )  
    }  
    while ( v <= last ) ;

  }
  catch( EndOfFile pe )               // Not error
  {
  }
  catch( PrimeException pe )          // Error
  {
    cout << pe.what() ;
    pause() ;                         // Wait for user
    return 2 ;
  }
                                      // Report completion
  cout_cerr << "\n " << fileName
            << " complete" << endl ;

	return 0 ;
}
