// BuildPrimeC2.cpp : Build compact prime file. Use as source
//   of primes with class PrimeCFile, or similar programming.

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                 // Microsoft boilerplate
#include "PrimeGeneratorC.hpp"      // Class PrimeGenerator
#include "StopWatch.hpp"            // Class StopWatch (timer)
#include "Progress.hpp"             // Class Progress report gate
#include "PrimeCArray.hpp"          // Class PrimeCArray
#include "PrimeCFileWriter.hpp"     // Class PrimeCFileWriter
#include "ostreamFork.hpp"          // Class ostreamFork
#include <fstream>                  // Class ofstream
#include <sstream>                  // Class stringstream
#include <iomanip>                  // setprecision(5) 
#include <string>                   // class string
  using namespace std ;

                         
int main( int argc , char* argv[] )
{
  showCommas( cout ) ;                    // Show commas in cout
  showCommas( cerr ) ;                    // Show commas in cerr
  ostreamFork report( cout , cerr ) ;     // One for display, one for file

  if ( argc != 3 )
  {
    report << "BuildPrimeC_2 First Last (miltiples of 20)" << endl ;
    return 1 ;
  }
  
  const string 
      firstStr( argv[1] ) ,        // Command parameters as strings
      lastStr(  argv[2] ) ;     

  PrimeRange  firstPrime ,         // Lower bound (n*20)
              lastPrime  ;         // Upper bound (n*20)
  try
  {                                     // String to unsigned long long
    firstPrime = stoull( firstStr ) ,   // Throws exception on error
    lastPrime  = stoull( lastStr  ) ;
  }
  catch( exception ex )
  {
     report << "First or Last conversion error: " 
               + firstStr + " , " + lastStr<< endl ;
     pause() ;
     return 1 ;
  }

  if ( ( 0 != (firstPrime % 20) ) | 
       ( 0 != (lastPrime  % 20) ) )
  {
    report << "First Last must be miltiples of 20." << endl ;
    pause() ;
    return 2 ;
  } 
           
                                   // For run time estimate
                                   // Range (not count) of primes
  const double 
    range( static_cast<double>( lastPrime - firstPrime )) ; 

  Prime     v ;
  StopWatch sw ;                  // Timer for run time estimate 

  PrimeCFileWriter pcf( firstPrime , lastPrime ) ;   // Resulting filr
  PrimeCArray      pca( firstPrime , lastPrime ) ;   // Internal work area
                                                     // pca copied to pcf
  try
  {
                                    // Generate primes from
                                    // firstPrime to lastPrime
    PrimeGeneratorC pg( firstPrime , lastPrime ) ;

    Progress p( 2.0 ) ;             // Display progress every 2 seconds
    report << endl ;
  
    while ( true )                  // Do until input EOF or v > lastPrime
    {
      v = pg.get() ;                // Get a prime from internal generator
      pca.set( v ) ;                // Write prime to file

      if ( p.go() )                 // Progress Timer expired ?
      {                             // Yes
        double  age  = sw.seconds() ;                  // Total time
        double  done = (v - firstPrime) / range ;      // Fraction finished
        double  remaining = ( (age / done) - age ) / 3600. ;

        cout << v << " : "                // Current prime
             << std::setprecision(3)      // Max believable
             << done * 100.               // % done
             << " % : hours running: " 
             << sw.hours()                // Hours running
             << "   hours elapsed: "
             << remaining                 // Estimated hours remaining
             << endl ;
             //   << " renmaining       \r" ;  // For fast output
      }  // End if (go() )
    }    // End while
  }
  catch( EndOfFile pe )              // Not error
  {                                  // Copy Array to file
    pca.computeCheck() ;             // Check sum
    pcf = pca ;                      // Copy work array to file 
  }
  catch( PrimeException pe )         // Error
  {
    cout << pe.what() ;
    pause() ;                        // Wait for user
    return 1 ;
  }
  catch( exception pe )              // Error
  {
    cout << pe.what() ;
    pause() ;                        // Wait for user
    return 1 ;
  }

	return 0 ;
}
