// BuildPrime4File.cpp -- Build prime files of 32 bit primes -- 2018-09-24
//   0_to_4294967291.prime4 
//   0_to_4294967291.primeC 
//   0_to_4294967291.txt 
// Creates files out of thin air, no input is required.

// I dedicate this code to the public domain, waiving all rights 
// to the work worldwide under copyright law, including all related 
// and neighboring rights, to the extent allowed by law. You can 
// copy, modify, distribute this work, even for commercial purposes, 
// all without asking permission. 
// Don Kostuch
// October, 2018
// 

#include "stdafx.h"                         // Microsoft boilerplate
#include "Prime.hpp"                        // Typedefs, exceptions
#include "PrimeGenerator.hpp"               // Class PrimeGenerator
#include "PrimeCFileWriter.hpp"             // Class PrimeCFileWriter
#include "ostreamFork.hpp"                  // Class ostreamFork,  cout_cerr

int main( int argc , char* argv[] )
{
  ofstream report( "32bitPrimeReport.txt" ) ;
  cout_cerr.setStream( cout , report ) ;            // Two report streams
  showCommas( cout ) ;
  showCommas( report ) ;

  string   fileName( "0_to_4294967291" ) ;          // Output file name

  ofstream prime4( fileName+".prime4" ,  
                   ios::out | ios::binary | ios::trunc ) ;

  ofstream primeTxt( fileName+".txt" ) ;

  PrimeCFileWriter primeC( 0 , 4294967292 ) ;   

  Progress p( 2.0 );                        // Report progress every 2 seconds
  StopWatch sw ;                            // Time intervals

  PrimeGenerator pg( 0 , Largest32bit ) ;   // Generate all 32 bit primes
  Prime v ;

  cout << "Building: "<< fileName + ".txt"    << endl ;
  cout << "Building: "<< fileName + ".prime4" << endl ;
  cout << "Building: "<< fileName + ".primec" << endl ;

  try
  {
    while( true )
    {
      v = pg.get() ;                   // Get a prime

      if ( v > Largest32bit )          // Beyond last 32 bit prime
      {                                // Yes. report and quit
        cout << fileName << " complete" << endl ;
        pause() ;
        return 0 ; 
      }

      unsigned long v32 = (unsigned long)(v) ;   // Truncate prime to 32 bits
           
      primeTxt << v << endl ;         // Write to txt file
      primeC.set( v ) ;               // Write to primeC file
                                               
      prime4.write( (char*)(&v32) ,   // Write to prime4 (32bit) file
                     sizeof(v32) ) ; 

      if ( p.go() )                   // Report progress every 2 seconds
      {
        cout << v << " : " 
             << sw.hours() << " hours   \r" ;      // No line advance
      }
    }
  }
  catch( FileError ex )    
  {
     cout << "File Error: " << ex.what() << endl ;
     pause() ;
     return 0 ; 
  }
  catch( EndOfFile ex )    // Last prime 
  {
     cout << "EOF: Last prime from PrimeGenerator." <<  ex.what() << endl ;
     cout << fileName << " complete" << endl ;
     pause() ;
     return 0 ; 
  }
  catch( exception ex )  
  {
     cout << ex.what() << endl ;
     pause() ;
     return 0 ; 
  }

  cout << "Should not exit here." << endl ;
  pause() ;
  return 1 ;
}