
# How to re-generate this ebook from the TEI master

This ebook was produced from a a TEI master in SGML encoding, included here with the `.tei` extension. To reproduce it, you will need install a number of tools and follow the following steps.

## Required tools

  * [Tei2html](https://github.com/jhellingman/tei2html). Clone using git or download the zip file.
  * Saxon, from [saxonica.com](http://www.saxonica.com/products.html).
  * Java.
  * Perl, for example [Strawberry Perl](http://strawberryperl.com/).
  * [ImageMagick](http://www.imagemagick.org/script/index.php) (install using `cpan`).
  * [sp 1.3.4](ftp://ftp.jclark.com/pub/sp/win32/sp1_3_4.zip), from [James Clark website](http://www.jclark.com/).
  * Zip, use [info-zip](http://www.info-zip.org/Zip.html).
  * [node.js](https://nodejs.org/en/).
  * mathjax-node-cli (install using `npm`).

For more details see the installation instructions at [tei2html](https://github.com/jhellingman/tei2html/blob/master/Wiki/Installation.md).

## Steps

  1. Install all the required tools; make sure the `tei2html/tools` directory is on the path.
  2. Run the perl script `perl -S tei2html.pl -h` one time. This will create a directory with all extracted TeX formulas.
  3. Run the perl script `perl -S convertFormulas.pl` in that directory. This will convert the formulas to SVG, etc.
  4. Run the perl script `perl -S tei2html.pl -e -h -f` once more, this will create a HTML file using the SVG's embedded (including essential metric information and an ePub file that includes the formulas in MathML format.

For more details, consult the [Wiki pages](https://github.com/jhellingman/tei2html/tree/master/Wiki) at the `tei2html` repository.
